IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_batchaddrespondentresponse]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_batchaddrespondentresponse]
GO
CREATE PROCEDURE [dbo].[Sp_batchaddrespondentresponse](
                @ProjectId   INT,
                @UserId      INT,
                @CollectMode INT,
                @RpsQuestion VARCHAR(10),
                @RpsMatrix   INT,
                @maxMention  INT,
                @RpsContent  NVARCHAR(100),
                @rpsType     INT)
AS
  -- BUT: Ajouter un code dans le premier espace vide sur une list de rpondent
  -- la list des rpondant se trouvant dans une table temporaire du nom 
  -- de #TargetRespondents
  --creer la liste des Updateables
  SELECT *
  INTO   #updateable_resp
  FROM   (SELECT   #targetrespondents.resrespondent,
                   Min(rpsmention) AS rpsmention
          FROM     #targetrespondents
                   INNER JOIN response
                     ON #targetrespondents.resrespondent = response.rpsrespondent
          WHERE    rpsmatrix = @RpsMatrix
                   AND rpsquestion = @RpsQuestion
                   AND rpscontent = ''
          GROUP BY #targetrespondents.resrespondent) resp;
  -- creer la liste des Insertables
  SELECT resrespondent,
         rpsmention + 1 AS rpsmention
  INTO   #insertable_resp
  FROM   (SELECT   #targetrespondents.resrespondent,
                   Max(rpsmention) AS rpsmention
          FROM     #targetrespondents
                   INNER JOIN response
                     ON #targetrespondents.resrespondent = response.rpsrespondent
          WHERE    rpsmatrix = @RpsMatrix
                   AND rpsquestion = @RpsQuestion
          GROUP BY #targetrespondents.resrespondent) resp
  WHERE  rpsmention < @maxMention
  -- DO the Update
  UPDATE response
  SET    rpscontent = @RpsContent
  FROM   response response
         INNER JOIN #updateable_resp target
           ON response.rpsrespondent = target.resrespondent
              AND response.rpsmention = target.rpsmention
  WHERE  response.rpsquestion = @RpsQuestion
         AND response.rpsmatrix = @RpsMatrix;
  -- DO The insert
  INSERT INTO response 
   (
   rpsrespondent,
   rpsquestion,
   rpsmatrix,
   rpsmention,
   rpscontent,
   rpsopened,
    rpstype,
   projectid,
   collectmode,
   modifiedby,
    modified
   )
  SELECT target.resrespondent AS rpsrespondent,
         @RpsQuestion         AS rpsquestion,
         @RpsMatrix           AS rpsmatrix,
         target.rpsmention,
         @RpsContent          AS rpscontent,
         ''                   AS rpsopened,
         @rpsType             AS rpstype,
         @projectId           AS projectid,
         @CollectMode         AS collectmode,
         @UserId              AS modifiedby,
         Getdate()            AS modified
  FROM   #insertable_resp AS target
  --Insert modif Log
  INSERT INTO responsemodiflog
             (respondent,
              question,
              matrix,
              mention,
              [Content],
              source,
              COMMENT,
              modifiedby,
              modified)
  SELECT target.resrespondent AS rpsrespondent,
         @RpsQuestion         AS rpsquestion,
         @RpsMatrix           AS rpsmatrix,
         target.rpsmention,
         @RpsContent          AS rpscontent,
         'OpenCodification'   AS source,
         'AddCode'            AS COMMENT,
         @UserId              AS modifiedby,
         Getdate()            AS modified
  FROM   #insertable_resp AS target

GO
